<?php
/**
 * Theme functions and definitions.
 *
 * For additional information on potential customization options,
 * read the developers' documentation:
 *
 * https://developers.elementor.com/docs/hello-elementor-theme/
 *
 * @package HelloElementorChild
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_CHILD_VERSION', '2.0.0' );

/**
 * Load child theme scripts & styles.
 *
 * @return void
 */
function hello_elementor_child_scripts_styles() {
	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		HELLO_ELEMENTOR_CHILD_VERSION
	);
}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_scripts_styles', 20 );

function fix_background_image_quotes( $content ) {
    $content = str_replace( "background-image: url('//", 'background-image: url("//', $content );
    $content = str_replace( "')", '")', $content );
    return $content;
}
add_filter( 'the_content', 'fix_background_image_quotes' );
add_filter( 'the_excerpt', 'fix_background_image_quotes' ); // If excerpts also have this issue

function allow_svg_upload( $mimes ) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter( 'upload_mimes', 'allow_svg_upload' );

function fix_svg_thumb_display() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
}
add_action( 'admin_head', 'fix_svg_thumb_display' );



function main_navigation_menu_shortcode() {
    ob_start();
    ?>
    <nav class="main-navigation">
        <ul class="nav-menu">
          
			            <li class="nav-item"><a href="https://ecoflow.enzymehub.gr/">Αρχική</a></li>

            <li class="nav-item"><a href="https://ecoflow.enzymehub.gr/about/">Λίγα λόγια για την Ecoflow</a></li>
			<li class="nav-item mega-menu-trigger">
                <a href="#">
                    Προϊόντα 
                    <span class="dropdown-arrow">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <polyline points="6 9 12 15 18 9"></polyline>
                        </svg>
                    </span>
                </a>
            </li>            </li>
            <li class="nav-item"><a href="https://ecoflow.enzymehub.gr/contact/">Επικοινωνία</a></li>
        </ul>
    </nav>

    <style>
    .main-navigation {
        background-color: transparent;
        height: 100%;
    }
    .nav-menu {
        display: flex;
        list-style: none;
        margin: 0;
        padding: 0;
        justify-content: center;
        height: 100%;
    }
    .nav-item {
        position: relative;
        padding: 15px;
        display: flex;
        align-items: center;
    }
    .nav-item a {
        text-decoration: none;
        color: #333;
        font-weight: bold;
		font-size:14px;
		font-family:'HelveticaNeue';
        display: flex;
        align-items: center;
        gap: 5px;
    }
		 .dropdown-arrow {
        display: inline-flex;
        align-items: center;
        transition: transform 0.3s ease;
    }
    .dropdown-arrow svg {
        width: 16px;
        height: 16px;
    }
    .nav-item.mega-menu-trigger:hover .dropdown-arrow {
        transform: rotate(180deg);
    }
    </style>

    <?php
    return ob_get_clean();
}
add_shortcode('main_navigation_menu', 'main_navigation_menu_shortcode');
function dynamic_full_width_navigation_mega_menu_shortcode() {
    ob_start();
    ?>
    <div class="mega-menu-container">
        <div class="mega-menu-full-width">
            <div class="mega-menu-wrapper">
                <div class="mega-menu-categories">
                    <?php
                    // Get top-level product categories
                    $top_level_categories = get_terms(array(
                        'taxonomy' => 'product_cat',
                        'hide_empty' => true,
                        'parent' => 0 // Only top-level categories
                    ));
                    ?>
                    <ul class="category-list">
                        <?php foreach ($top_level_categories as $index => $top_category): ?>
                            <li class="parent-category" 
                                data-category-id="<?php echo $top_category->term_id; ?>"
                                <?php echo ($index === 0) ? 'class="active"' : ''; ?>>
                                <?php echo $top_category->name; ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <div class="mega-menu-products">
                    <div class="products-container" id="products-container">
                        <p class="initial-message">Φόρτωση...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

     <script>
    document.addEventListener('DOMContentLoaded', function() {
        const mainNavigation = document.querySelector('.main-navigation');
        const megaMenuContainer = document.querySelector('.mega-menu-container');
        const categoryList = megaMenuContainer.querySelector('.category-list');
        const productsContainer = document.getElementById('products-container');
        const megaMenuTrigger = mainNavigation?.querySelector('.mega-menu-trigger');
        let hoverTimeout;
        let megaMenuHideTimeout;

        // Function to load products
        function loadCategoryProducts(categoryId) {
            fetch('<?php echo admin_url('admin-ajax.php'); ?>?action=get_category_products&category_id=' + categoryId)
                .then(response => response.text())
                .then(html => {
                    productsContainer.innerHTML = html;
                })
                .catch(error => {
                    console.error('Error:', error);
                    productsContainer.innerHTML = '<p>Error loading products</p>';
                });
        }

        // Handle parent category hover to load products
        categoryList.addEventListener('mouseover', function(e) {
            const parentCategory = e.target.closest('.parent-category');

            if (parentCategory) {
                // Remove active class from all parent categories
                document.querySelectorAll('.parent-category').forEach(cat => {
                    cat.classList.remove('active');
                });
                parentCategory.classList.add('active');

                // Load products for the hovered category
                const categoryId = parentCategory.getAttribute('data-category-id');
                loadCategoryProducts(categoryId);
            }
        });

        // Mega menu visibility logic
        if (megaMenuTrigger && megaMenuContainer) {
            megaMenuTrigger.addEventListener('mouseenter', function() {
                if (megaMenuHideTimeout) {
                    clearTimeout(megaMenuHideTimeout);
                }

                megaMenuContainer.style.display = 'block';
                
                // Load products for the first category
                const firstCategory = document.querySelector('.parent-category');
                if (firstCategory) {
                    const categoryId = firstCategory.getAttribute('data-category-id');
                    loadCategoryProducts(categoryId);
                }
            });

            megaMenuTrigger.addEventListener('mouseleave', function(e) {
                megaMenuHideTimeout = setTimeout(() => {
                    if (!megaMenuContainer.matches(':hover')) {
                        megaMenuContainer.style.display = 'none';
                    }
                }, 200);
            });

            megaMenuContainer.addEventListener('mouseleave', function() {
                this.style.display = 'none';
            });
        }
    });
    </script>

      <style>
    .mega-menu-container {
        display: none;
        position: absolute;
        top: 100%;
        left: 0;
        width: 100vw;
        background-color: white;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        z-index: 1000;
        margin-left: calc(-50vw + 50%);
    }
    .mega-menu-full-width {
        max-width: 1200px;
        margin: 0 auto;
        padding: 20px 0;
    }
    .mega-menu-wrapper {
        display: flex;
        width: 100%;
    }
    .mega-menu-categories {
        width: 30%;
        border-right: 1px solid #e0e0e0;
        padding-right: 20px;
    }
    .mega-menu-products {
        width: 70%;
        padding-left: 20px;
    }
    .category-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }
    .parent-category {
        padding: 10px;
        cursor: pointer;
        transition: background-color 0.3s;
    }
    .parent-category:hover,
    .parent-category.active {
        background-color: #f0f0f0;
    }
    .products-grid {
        display: grid;
        grid-template-columns: repeat(5, 1fr);
        gap: 10px;
    }
    .product-item {
       text-align: center;
        background-color: white; 
        padding: 15px;
        border-radius: 8px;
        display: flex;
        flex-direction: column;
        align-items: center;
		border:1px solid rgba(211,211,211,0.2);
		border-radius:5px;
    }
    .product-item img {
        max-width: 100px;
        height: auto;
        object-fit: contain;
        margin-bottom: 10px;
    }
    .product-item h4 {
        margin: 5px 0;
        font-size: 0.9em;
    }
    .product-item h4 a {
        color: #333;
        text-decoration: none;
    }
    .product-item p {
        font-size: 0.8em;
        margin: 5px 0;
        color: #666;
        text-align: center;
    }
    </style>
    <?php
    return ob_get_clean();
}
add_shortcode('dynamic_full_width_navigation_mega_menu', 'dynamic_full_width_navigation_mega_menu_shortcode');

// AJAX handler to fetch products by category (remains the same as in the original code)
function get_category_products_ajax() {
    $category_id = intval($_GET['category_id']);
    
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => 12,
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field'    => 'term_id',
                'terms'    => $category_id,
            ),
        ),
    );
    
    $query = new WP_Query($args);
    
    if ($query->have_posts()) {
        echo '<div class="products-grid">';
        while ($query->have_posts()) {
            $query->the_post();
            ?>
            <div class="product-item">
                 <?php 
					// Display product image with link
					if (has_post_thumbnail()) {
						?>
						<a href="<?php the_permalink(); ?>">
							<?php the_post_thumbnail('thumbnail'); ?>
						</a>
						<?php
					}
					?>
                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <p><?php echo wp_trim_words(get_the_excerpt(), 10); ?></p>
            </div>
            <?php
        }
        echo '</div>';
        wp_reset_postdata();
    } else {
        echo '<p>No products found in this category.</p>';
    }
    
    wp_die();
}
add_action('wp_ajax_get_category_products', 'get_category_products_ajax');
add_action('wp_ajax_nopriv_get_category_products', 'get_category_products_ajax');

// Disable woocommerce recently viewed cookie
add_filter( 'woocommerce_recently_viewed_products_cookie_enabled', '__return_false' );