<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
/* Default comment here */ 

document.addEventListener('DOMContentLoaded', function() {
    const megaMenuTrigger = document.querySelector('.nav-item.mega-menu-trigger');
    const megaMenuContainer = document.querySelector('.mega-menu-container');
    const productsContainer = document.getElementById('products-container');
    const categoryList = document.querySelector('.category-list');

    // Function to load products
    function loadCategoryProducts(categoryId) {
        // Use WordPress AJAX to fetch products
        fetch(megaMenuAjax.ajax_url + '?action=get_category_products&category_id=' + categoryId)
            .then(response => response.text())
            .then(html => {
                productsContainer.innerHTML = html;
            })
            .catch(error => {
                console.error('Error:', error);
                productsContainer.innerHTML = '<p>Error loading products</p>';
            });
    }

    // Show mega menu
    function showMegaMenu() {
        megaMenuContainer.style.display = 'block';

        // Load first available category's products
        const firstCategory = document.querySelector('.parent-category');
        if (firstCategory) {
            const categoryId = firstCategory.getAttribute('data-category-id');
            loadCategoryProducts(categoryId);
            
            // Remove active class from all categories
            document.querySelectorAll('.parent-category').forEach(cat => {
                cat.classList.remove('active');
            });
            firstCategory.classList.add('active');
        }
    }

    // Hide mega menu
    function hideMegaMenu() {
        megaMenuContainer.style.display = 'none';
    }

    // Attach hover events to parent categories
    const parentCategories = document.querySelectorAll('.parent-category');
    parentCategories.forEach(category => {
        category.addEventListener('mouseenter', function() {
            // Remove active class from all categories
            parentCategories.forEach(cat => {
                cat.classList.remove('active');
            });
            this.classList.add('active');

            // Load products for the hovered category
            const categoryId = this.getAttribute('data-category-id');
            loadCategoryProducts(categoryId);
        });
    });

    // Show/hide mega menu on trigger hover
    if (megaMenuTrigger) {
        megaMenuTrigger.addEventListener('mouseenter', showMegaMenu);
        megaMenuTrigger.addEventListener('mouseleave', function() {
            // Short delay to prevent accidental hiding
            setTimeout(hideMegaMenu, 200);
        });

        // Prevent menu from closing immediately
        megaMenuContainer.addEventListener('mouseenter', function() {
            megaMenuContainer.style.display = 'block';
        });
        megaMenuContainer.addEventListener('mouseleave', hideMegaMenu);
    }
});</script>
<!-- end Simple Custom CSS and JS -->
